<?php
require '../includes/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') {
    die("Acceso denegado");
}

$id = $_GET['id'];

// 1. Obtener los productos vendidos para devolver al stock
$stmt = $pdo->prepare("SELECT item_id, cantidad FROM sale_details WHERE sale_id = ? AND item_type = 'producto'");
$stmt->execute([$id]);
$productos = $stmt->fetchAll();

foreach($productos as $p) {
    // Devolver stock
    $upd = $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?");
    $upd->execute([$p['cantidad'], $p['item_id']]);
}

// 2. Marcar venta como ANULADA (No la borramos físicamente para auditoría)
$stmt = $pdo->prepare("UPDATE sales SET estado = 'anulada' WHERE id = ?");
if($stmt->execute([$id])) {
    header("Location: reportes.php?msg=anulada");
} else {
    echo "Error al anular.";
}
?>