<?php
require '../includes/db.php';
include '../includes/header.php';

// Solo Admin
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') { header("Location: ../index.php"); exit; }

$fecha = isset($_GET['fecha']) ? $_GET['fecha'] : date('Y-m-d');

// OBJETIVO: Comparar conteos por Barbero en el día seleccionado

// 1. Obtener lista de barberos
$barberos = $pdo->query("SELECT id, nombre, apellido FROM users WHERE rol='barbero' AND activo=1")->fetchAll();

$auditoria = [];

foreach($barberos as $b) {
    // A. Lo que el barbero DICE que hizo (work_logs)
    $sqlDice = "SELECT COUNT(*) as cant_dice, SUM(comision_estimada) as total_dice 
                FROM work_logs 
                WHERE barbero_id = ? AND DATE(fecha_registro) = ?";
    $stmtD = $pdo->prepare($sqlDice);
    $stmtD->execute([$b['id'], $fecha]);
    $dice = $stmtD->fetch();

    // B. Lo que la Caja COBRÓ (sale_details + sales)
    $sqlReal = "SELECT COUNT(*) as cant_real, SUM(sd.comision_monto) as total_real
                FROM sale_details sd
                JOIN sales s ON sd.sale_id = s.id
                WHERE s.barbero_id = ? 
                AND sd.item_type = 'servicio' 
                AND s.estado = 'pagada'
                AND DATE(s.fecha_creacion) = ?";
    $stmtR = $pdo->prepare($sqlReal);
    $stmtR->execute([$b['id'], $fecha]);
    $real = $stmtR->fetch();

    // Calculamos diferencia
    $dif_cantidad = $real['cant_real'] - $dice['cant_dice']; // Real - Dice
    
    $auditoria[] = [
        'nombre' => $b['nombre'] . ' ' . $b['apellido'],
        'dice_cant' => $dice['cant_dice'],
        'real_cant' => $real['cant_real'],
        'dif_cant' => $dif_cantidad,
        'dice_dinero' => $dice['total_dice'],
        'real_dinero' => $real['total_real']
    ];
}
?>

<div class="row mb-4">
    <div class="col-md-8">
        <h2 class="text-gold"><i class="fas fa-balance-scale"></i> Auditoría Operativa</h2>
        <p class="text-muted">Comparativa entre lo reportado por el Barbero vs. lo Cobrado en Caja.</p>
    </div>
    <div class="col-md-4">
        <form method="GET" class="d-flex gap-2 align-items-center">
            <label class="text-white">Fecha:</label>
            <input type="date" name="fecha" class="form-control bg-secondary text-white border-0" value="<?php echo $fecha; ?>">
            <button type="submit" class="btn btn-gold">Auditar</button>
        </form>
    </div>
</div>

<div class="card border-warning">
    <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle text-center">
            <thead>
                <tr>
                    <th class="text-start">Barbero</th>
                    <th class="text-info">Reportado (Barbero)</th>
                    <th class="text-success">Cobrado (Caja)</th>
                    <th>Diferencia</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($auditoria as $a): ?>
                <tr>
                    <td class="text-start py-3 fw-bold"><?php echo $a['nombre']; ?></td>
                    
                    <td class="text-info bg-dark border-secondary">
                        <span class="h5"><?php echo $a['dice_cant']; ?></span> servicios<br>
                        <small class="text-muted">Est. $<?php echo number_format($a['dice_dinero'], 2); ?></small>
                    </td>
                    
                    <td class="text-success bg-dark border-secondary">
                        <span class="h5"><?php echo $a['real_cant']; ?></span> servicios<br>
                        <small class="text-muted">Real $<?php echo number_format($a['real_dinero'], 2); ?></small>
                    </td>
                    
                    <td>
                        <?php if($a['dif_cant'] == 0): ?>
                            <span class="badge bg-success text-dark">Exacto (0)</span>
                        <?php elseif($a['dif_cant'] > 0): ?>
                            <span class="badge bg-warning text-dark">+<?php echo $a['dif_cant']; ?> en Caja</span>
                            <div style="font-size:0.7em; color:#aaa;">(El barbero olvidó anotar)</div>
                        <?php else: ?>
                            <span class="badge bg-danger">-<?php echo abs($a['dif_cant']); ?> en Caja</span>
                            <div style="font-size:0.7em; color:#ff6b6b;">(POSIBLE FUGA DE DINERO)</div>
                        <?php endif; ?>
                    </td>
                    
                    <td>
                        <?php if($a['dif_cant'] == 0): ?>
                            <i class="fas fa-check-circle text-success fa-2x"></i>
                        <?php elseif($a['dif_cant'] < 0): ?>
                            <i class="fas fa-exclamation-triangle text-danger fa-2x blink"></i>
                        <?php else: ?>
                            <i class="fas fa-info-circle text-warning fa-2x"></i>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
    .blink { animation: blinker 1.5s linear infinite; }
    @keyframes blinker { 50% { opacity: 0; } }
</style>

<?php include '../includes/footer.php'; ?>