<?php
require '../includes/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') {
    header("Location: ../index.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];
    
    if ($action == 'delete') {
        $id = $_POST['id'];
        $stmt = $pdo->prepare("UPDATE products SET activo = 0 WHERE id = ?");
        $stmt->execute([$id]);
    } else {
        $nombre = $_POST['nombre'];
        $tipo = $_POST['tipo'];
        $stock = $_POST['stock'];
        $p_compra = $_POST['precio_compra'];
        $p_venta = $_POST['precio_venta'];
        
        if ($action == 'create') {
            $stmt = $pdo->prepare("INSERT INTO products (nombre, tipo, stock, precio_compra, precio_venta) VALUES (?, ?, ?, ?, ?)");
            $stmt->execute([$nombre, $tipo, $stock, $p_compra, $p_venta]);
        } elseif ($action == 'edit') {
            $id = $_POST['id'];
            $stmt = $pdo->prepare("UPDATE products SET nombre=?, tipo=?, stock=?, precio_compra=?, precio_venta=? WHERE id=?");
            $stmt->execute([$nombre, $tipo, $stock, $p_compra, $p_venta, $id]);
        }
    }
    header("Location: productos.php");
    exit;
}

$stmt = $pdo->query("SELECT * FROM products WHERE activo = 1 ORDER BY tipo ASC, nombre ASC");
$productos = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="text-gold"><i class="fas fa-boxes"></i> Inventario de Productos</h2>
    <button class="btn btn-gold" data-bs-toggle="modal" data-bs-target="#modalProducto" onclick="limpiarModal()">
        <i class="fas fa-plus"></i> Nuevo Producto
    </button>
</div>

<div class="card">
    <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle">
            <thead>
                <tr>
                    <th class="text-gold">Tipo</th>
                    <th class="text-gold">Producto</th>
                    <th class="text-gold text-center">Stock</th>
                    <th class="text-gold">P. Compra</th>
                    <th class="text-gold">P. Venta</th>
                    <th class="text-gold text-end">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($productos as $p): ?>
                <tr>
                    <td>
                        <?php 
                        if($p['tipo'] == 'producto_capilar') echo '<span class="badge bg-primary">Capilar</span>';
                        elseif($p['tipo'] == 'snack') echo '<span class="badge bg-warning text-dark">Snack</span>';
                        else echo '<span class="badge bg-success">Bebida</span>';
                        ?>
                    </td>
                    <td><?php echo $p['nombre']; ?></td>
                    <td class="text-center">
                        <?php if($p['stock'] <= 5): ?>
                            <span class="text-danger fw-bold"><?php echo $p['stock']; ?> (Bajo)</span>
                        <?php else: ?>
                            <span class="text-success"><?php echo $p['stock']; ?></span>
                        <?php endif; ?>
                    </td>
                    <td>$<?php echo number_format($p['precio_compra'], 2); ?></td>
                    <td><strong>$<?php echo number_format($p['precio_venta'], 2); ?></strong></td>
                    <td class="text-end">
                        <button class="btn btn-sm btn-outline-warning" onclick="editar(<?php echo htmlspecialchars(json_encode($p)); ?>)">
                            <i class="fas fa-edit"></i>
                        </button>
                        <form method="POST" style="display:inline-block;" onsubmit="return confirm('¿Borrar producto?');">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="id" value="<?php echo $p['id']; ?>">
                            <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalProducto" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white border-warning">
            <form method="POST">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title text-gold" id="modalTitle">Nuevo Producto</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" id="action" value="create">
                    <input type="hidden" name="id" id="id">
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Nombre</label>
                            <input type="text" name="nombre" id="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Tipo</label>
                            <select name="tipo" id="tipo" class="form-select bg-secondary text-white border-0" required>
                                <option value="producto_capilar">Cuidado Capilar</option>
                                <option value="snack">Snack (Comida)</option>
                                <option value="bebida">Bebida</option>
                            </select>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>Stock Inicial</label>
                        <input type="number" name="stock" id="stock" class="form-control" required>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Precio Compra ($)</label>
                            <input type="number" step="0.01" name="precio_compra" id="precio_compra" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Precio Venta ($)</label>
                            <input type="number" step="0.01" name="precio_venta" id="precio_venta" class="form-control" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-gold">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function limpiarModal() {
    document.getElementById('modalTitle').innerText = 'Nuevo Producto';
    document.getElementById('action').value = 'create';
    document.getElementById('nombre').value = '';
    document.getElementById('stock').value = '';
    document.getElementById('precio_compra').value = '';
    document.getElementById('precio_venta').value = '';
}

function editar(data) {
    var modal = new bootstrap.Modal(document.getElementById('modalProducto'));
    document.getElementById('modalTitle').innerText = 'Editar Producto';
    document.getElementById('action').value = 'edit';
    document.getElementById('id').value = data.id;
    document.getElementById('nombre').value = data.nombre;
    document.getElementById('tipo').value = data.tipo;
    document.getElementById('stock').value = data.stock;
    document.getElementById('precio_compra').value = data.precio_compra;
    document.getElementById('precio_venta').value = data.precio_venta;
    modal.show();
}
</script>

<?php include '../includes/footer.php'; ?>