<?php
require '../includes/db.php';
// Seguridad: Solo Admin
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') {
    header("Location: ../index.php");
    exit;
}

// PROCESAR FORMULARIO (Crear / Editar / Eliminar)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];
    
    if ($action == 'delete') {
        // Borrado lógico (Soft Delete) para no romper historial de ventas
        $id = $_POST['id'];
        $stmt = $pdo->prepare("UPDATE services SET activo = 0 WHERE id = ?");
        $stmt->execute([$id]);
    } else {
        $nombre = $_POST['nombre'];
        $descripcion = $_POST['descripcion'];
        $precio = $_POST['precio'];
        // Si el checkbox no se marca, no envía valor, por eso usamos isset
        $requiere_lavado = isset($_POST['requiere_lavado']) ? 1 : 0; 
        
        if ($action == 'create') {
            $stmt = $pdo->prepare("INSERT INTO services (nombre, descripcion, precio, requiere_lavado) VALUES (?, ?, ?, ?)");
            $stmt->execute([$nombre, $descripcion, $precio, $requiere_lavado]);
        } elseif ($action == 'edit') {
            $id = $_POST['id'];
            $stmt = $pdo->prepare("UPDATE services SET nombre=?, descripcion=?, precio=?, requiere_lavado=? WHERE id=?");
            $stmt->execute([$nombre, $descripcion, $precio, $requiere_lavado, $id]);
        }
    }
    header("Location: servicios.php"); // Recargar para ver cambios
    exit;
}

// OBTENER SERVICIOS
$stmt = $pdo->query("SELECT * FROM services WHERE activo = 1 ORDER BY nombre ASC");
$servicios = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="text-gold"><i class="fas fa-cut"></i> Gestión de Servicios</h2>
    <button class="btn btn-gold" data-bs-toggle="modal" data-bs-target="#modalServicio" onclick="limpiarModal()">
        <i class="fas fa-plus"></i> Nuevo Servicio
    </button>
</div>

<div class="card">
    <div class="card-body table-responsive">
        <table class="table table-dark table-hover">
            <thead>
                <tr>
                    <th class="text-gold">Servicio</th>
                    <th class="text-gold">Descripción</th>
                    <th class="text-gold">Precio ($)</th>
                    <th class="text-gold">Lavado incl.</th>
                    <th class="text-gold text-end">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($servicios as $s): ?>
                <tr>
                    <td><?php echo $s['nombre']; ?></td>
                    <td><?php echo $s['descripcion']; ?></td>
                    <td><strong>$<?php echo number_format($s['precio'], 2); ?></strong></td>
                    <td>
                        <?php if($s['requiere_lavado']): ?>
                            <span class="badge bg-info text-dark">Sí (-$1 Base)</span>
                        <?php else: ?>
                            <span class="badge bg-secondary">No</span>
                        <?php endif; ?>
                    </td>
                    <td class="text-end">
                        <button class="btn btn-sm btn-outline-warning" 
                                onclick="editar(<?php echo htmlspecialchars(json_encode($s)); ?>)">
                            <i class="fas fa-edit"></i>
                        </button>
                        <form method="POST" style="display:inline-block;" onsubmit="return confirm('¿Seguro que deseas eliminar este servicio?');">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="id" value="<?php echo $s['id']; ?>">
                            <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalServicio" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white border-warning">
            <form method="POST">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title text-gold" id="modalTitle">Nuevo Servicio</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" id="action" value="create">
                    <input type="hidden" name="id" id="id">
                    
                    <div class="mb-3">
                        <label>Nombre del Servicio</label>
                        <input type="text" name="nombre" id="nombre" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Descripción</label>
                        <textarea name="descripcion" id="descripcion" class="form-control" rows="2"></textarea>
                    </div>
                    <div class="mb-3">
                        <label>Precio de Venta ($)</label>
                        <input type="number" step="0.01" name="precio" id="precio" class="form-control" required>
                    </div>
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" name="requiere_lavado" id="requiere_lavado">
                        <label class="form-check-label" for="requiere_lavado">¿Incluye Lavado? (Descontará $1 para insumos)</label>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-gold">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function limpiarModal() {
    document.getElementById('modalTitle').innerText = 'Nuevo Servicio';
    document.getElementById('action').value = 'create';
    document.getElementById('nombre').value = '';
    document.getElementById('descripcion').value = '';
    document.getElementById('precio').value = '';
    document.getElementById('requiere_lavado').checked = false;
}

function editar(data) {
    var modal = new bootstrap.Modal(document.getElementById('modalServicio'));
    document.getElementById('modalTitle').innerText = 'Editar Servicio';
    document.getElementById('action').value = 'edit';
    document.getElementById('id').value = data.id;
    document.getElementById('nombre').value = data.nombre;
    document.getElementById('descripcion').value = data.descripcion;
    document.getElementById('precio').value = data.precio;
    document.getElementById('requiere_lavado').checked = (data.requiere_lavado == 1);
    modal.show();
}
</script>

<?php include '../includes/footer.php'; ?>