<?php 
// 1. Iniciamos sesión si no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. LÓGICA DE RUTAS DINÁMICAS (El arreglo mágico)
// Detectamos si el archivo actual está dentro de la carpeta "modules"
$script_name = $_SERVER['SCRIPT_NAME']; // Ejemplo: /barberia/modules/caja.php

if (strpos($script_name, '/modules/') !== false) {
    // Si estamos dentro de 'modules', tenemos que salir una carpeta hacia atrás
    $path_root = "../"; 
} else {
    // Si estamos en la raíz (ej. dashboard.php), nos quedamos ahí
    $path_root = "./";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Barber System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --color-gold: #d4af37;
            --color-black: #1a1a1a;
            --color-dark-grey: #2c2c2c;
        }
        body {
            background-color: var(--color-black);
            color: #ffffff;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .card {
            background-color: var(--color-dark-grey);
            border: 1px solid var(--color-gold);
            color: white;
        }
        .text-gold { color: var(--color-gold) !important; }
        .bg-gold { background-color: var(--color-gold) !important; color: black; }
        
        .btn-gold {
            background-color: var(--color-gold);
            color: #000;
            font-weight: bold;
            border: none;
        }
        .btn-gold:hover {
            background-color: #b59025;
            color: #fff;
        }
        .form-control, .form-select {
            background-color: #444;
            border: 1px solid #666;
            color: white;
        }
        .form-control:focus, .form-select:focus {
            background-color: #555;
            color: white;
            border-color: var(--color-gold);
            box-shadow: 0 0 5px var(--color-gold);
        }
        .navbar {
            border-bottom: 2px solid var(--color-gold);
            background-color: #000;
        }
        .nav-link { color: #fff !important; }
        .nav-link.active { color: var(--color-gold) !important; font-weight: bold; }
        .nav-link:hover { color: var(--color-gold) !important; }
        
        /* Estilos para tablas */
        .table-dark { background-color: var(--color-dark-grey); }
        .table-dark th { color: var(--color-gold); }
        
        /* Dropdown menú oscuro */
        .dropdown-menu-dark { background-color: var(--color-dark-grey); border: 1px solid var(--color-gold); }
        .dropdown-item { color: white; }
        .dropdown-item:hover { background-color: var(--color-gold); color: black; }
    </style>
</head>
<body>

<?php if(isset($_SESSION['user_id'])): ?>
<nav class="navbar navbar-expand-lg navbar-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand text-gold" href="<?php echo $path_root; ?>dashboard.php">
   <img src="<?php echo $path_root; ?>img/logosintexto.jpeg" alt="Logo" width="40" height="40" class="d-inline-block align-text-top me-2">
</a>
    
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        
        <?php if($_SESSION['rol'] == 'admin'): ?>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo $path_root; ?>dashboard.php">Inicio</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo $path_root; ?>modules/caja.php"><i class="fas fa-cash-register"></i> Caja</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?php echo $path_root; ?>modules/auditoria.php"><i class="fas fa-clipboard-check"></i> Auditoría</a>
            </li>
            
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Gestión</a>
                <ul class="dropdown-menu dropdown-menu-dark">
                    <li><a class="dropdown-item" href="<?php echo $path_root; ?>modules/servicios.php">Servicios</a></li>
                    <li><a class="dropdown-item" href="<?php echo $path_root; ?>modules/productos.php">Inventario</a></li>
                    <li><a class="dropdown-item" href="<?php echo $path_root; ?>modules/barberos.php">Barberos</a></li>
                    <li><a class="dropdown-item" href="<?php echo $path_root; ?>modules/clientes.php">Clientes</a></li>
                </ul>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="<?php echo $path_root; ?>modules/reportes.php"><i class="fas fa-chart-line"></i> Reportes & Nómina</a>
            </li>

        <?php else: ?>
            <li class="nav-item">
                <a class="nav-link active" href="<?php echo $path_root; ?>modules/mis_servicios.php"><i class="fas fa-cut"></i> MIS SERVICIOS</a>
            </li>
        <?php endif; ?>
        
      </ul>
      
      <div class="d-flex align-items-center">
          <span class="navbar-text text-white me-3 d-none d-md-block">
            <small class="text-muted">Usuario:</small> <span class="text-gold fw-bold"><?php echo $_SESSION['nombre']; ?></span>
          </span>
          <a href="<?php echo $path_root; ?>logout.php" class="btn btn-outline-danger btn-sm"><i class="fas fa-sign-out-alt"></i> Salir</a>
      </div>
    </div>
  </div>
</nav>
<?php endif; ?>

<div class="container">