<?php
require '../includes/db.php';
include '../includes/header.php';

// Obtener datos para los selectores
$clientes = $pdo->query("SELECT id, nombre, apellido, cedula FROM clients ORDER BY nombre ASC")->fetchAll();
$barberos = $pdo->query("SELECT id, nombre, apellido FROM users WHERE rol='barbero' AND activo=1 ORDER BY nombre ASC")->fetchAll();

// Obtener Servicios y Productos Activos
$servicios = $pdo->query("SELECT * FROM services WHERE activo=1 ORDER BY nombre ASC")->fetchAll();
$productos = $pdo->query("SELECT * FROM products WHERE activo=1 AND stock > 0 ORDER BY tipo ASC, nombre ASC")->fetchAll();
?>

<div class="row">
    <div class="col-md-7">
        <div class="card mb-3">
            <div class="card-header bg-gold fw-bold">1. Datos de la Venta</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="text-gold">Cliente</label>
                        <div class="input-group">
                            <select id="selectCliente" class="form-control form-select">
                                <option value="">-- Seleccionar Cliente --</option>
                                <?php foreach($clientes as $c): ?>
                                    <option value="<?php echo $c['id']; ?>"><?php echo $c['nombre'] . ' ' . $c['apellido'] . ' (' . $c['cedula'] . ')'; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <a href="clientes.php" class="btn btn-outline-secondary" title="Nuevo Cliente"><i class="fas fa-plus"></i></a>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="text-gold">Barbero</label>
                        <select id="selectBarbero" class="form-control form-select">
                            <option value="">-- Seleccionar Barbero --</option>
                            <?php foreach($barberos as $b): ?>
                                <option value="<?php echo $b['id']; ?>"><?php echo $b['nombre'] . ' ' . $b['apellido']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header bg-gold fw-bold">2. Agregar Ítems</div>
            <div class="card-body">
                <ul class="nav nav-tabs border-secondary mb-3" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active text-white" id="servicios-tab" data-bs-toggle="tab" data-bs-target="#tab-servicios" type="button">Servicios</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link text-white" id="productos-tab" data-bs-toggle="tab" data-bs-target="#tab-productos" type="button">Productos / Snacks</button>
                    </li>
                </ul>
                
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="tab-servicios">
                        <div class="row g-2">
                            <?php foreach($servicios as $s): ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="card bg-dark border-secondary h-100" style="cursor: pointer;" 
                                     onclick="agregarItem(<?php echo $s['id']; ?>, '<?php echo $s['nombre']; ?>', <?php echo $s['precio']; ?>, 'servicio')">
                                    <div class="card-body text-center p-2">
                                        <h6 class="text-white mb-1"><?php echo $s['nombre']; ?></h6>
                                        <small class="text-gold fw-bold">$<?php echo number_format($s['precio'], 2); ?></small>
                                        <?php if($s['requiere_lavado']): ?>
                                            <br><small class="text-info" style="font-size: 0.7em;">(Lavado Incl.)</small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="tab-productos">
                        <div class="row g-2">
                            <?php foreach($productos as $p): ?>
                            <div class="col-md-4 col-sm-6">
                                <div class="card bg-dark border-secondary h-100" style="cursor: pointer;" 
                                     onclick="agregarItem(<?php echo $p['id']; ?>, '<?php echo $p['nombre']; ?>', <?php echo $p['precio_venta']; ?>, 'producto')">
                                    <div class="card-body text-center p-2">
                                        <?php 
                                            $icon = 'fa-box';
                                            if($p['tipo']=='snack') $icon = 'fa-cookie-bite';
                                            if($p['tipo']=='bebida') $icon = 'fa-wine-bottle';
                                        ?>
                                        <i class="fas <?php echo $icon; ?> text-secondary mb-1"></i>
                                        <h6 class="text-white mb-1"><?php echo $p['nombre']; ?></h6>
                                        <small class="text-gold fw-bold">$<?php echo number_format($p['precio_venta'], 2); ?></small>
                                        <div class="text-muted" style="font-size: 0.7em;">Stock: <?php echo $p['stock']; ?></div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-5">
        <div class="card h-100 border-warning">
            <div class="card-header bg-black text-center border-bottom border-warning">
                <h4 class="text-gold mb-0">TICKET DE VENTA</h4>
            </div>
            <div class="card-body d-flex flex-column">
                <div class="table-responsive flex-grow-1">
                    <table class="table table-dark table-sm">
                        <thead>
                            <tr>
                                <th>Cant</th>
                                <th>Desc</th>
                                <th>Total</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody id="lista-items">
                            </tbody>
                    </table>
                </div>
                
                <div class="mt-auto border-top border-secondary pt-3">
                    <div class="d-flex justify-content-between h4">
                        <span>TOTAL A PAGAR:</span>
                        <span class="text-gold" id="total-pagar">$0.00</span>
                    </div>
                    <button class="btn btn-gold w-100 py-3 mt-3" onclick="abrirModalPago()">
                        <i class="fas fa-money-bill-wave"></i> COBRAR
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalPago" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white border-warning">
            <div class="modal-header border-secondary">
                <h5 class="modal-title text-gold">Finalizar Venta</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label>Método de Pago</label>
                    <select id="metodo_pago" class="form-select" onchange="toggleBancos()">
                        <option value="efectivo_usd">Efectivo ($ USD)</option>
                        <option value="efectivo_bs">Efectivo (Bolívares)</option>
                        <option value="pago_movil">Pago Móvil</option>
                        <option value="transferencia">Transferencia Bancaria</option>
                        <option value="zelle">Zelle</option>
                        <option value="binance">Binance</option>
                    </select>
                </div>
                <div class="row">
    <div class="col-md-6 mb-3">
        <label class="text-gold fw-bold">Propina para Barbero ($)</label>
        <input type="number" id="propina" class="form-control border-gold text-warning fw-bold" value="0.00" step="0.50" onkeyup="recalcularTotalPago()" onchange="recalcularTotalPago()">
    </div>
</div>

<h3 class="text-center text-gold mt-3">
    Total a Cobrar: <span id="modal-total-pagar">$0.00</span>
</h3>

                <div id="datos_bancarios" style="display:none;">
                    <div class="mb-3">
                        <label>Banco de Origen</label>
                        <input type="text" id="banco" class="form-control" placeholder="Ej: Banesco, Mercantil">
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Referencia / Comprobante</label>
                            <input type="text" id="referencia" class="form-control">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Fecha Transferencia</label>
                            <input type="date" id="fecha_pago" class="form-control" value="<?php echo date('Y-m-d'); ?>">
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <label>Observaciones (Opcional)</label>
                    <textarea id="observaciones" class="form-control" rows="2"></textarea>
                </div>
                
                <h3 class="text-center text-gold mt-3" id="modal-total-pagar">$0.00</h3>
            </div>
            <div class="modal-footer border-secondary">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-gold" onclick="procesarVenta()">Confirmar Pago</button>
            </div>
        </div>
    </div>
</div>
<script>
let carrito = [];
let subtotalCarrito = 0; // Variable global para guardar el total de items sin propina

function agregarItem(id, nombre, precio, tipo) {
    // Buscar si ya existe para sumar cantidad
    let existente = carrito.find(item => item.id === id && item.tipo === tipo);
    if (existente) {
        existente.cantidad++;
    } else {
        carrito.push({ id: id, nombre: nombre, precio: precio, tipo: tipo, cantidad: 1 });
    }
    renderizarCarrito();
}

function eliminarItem(index) {
    carrito.splice(index, 1);
    renderizarCarrito();
}

function renderizarCarrito() {
    let tbody = document.getElementById('lista-items');
    tbody.innerHTML = '';
    let total = 0;

    carrito.forEach((item, index) => {
        let subtotal = item.precio * item.cantidad;
        total += subtotal;
        
        let row = `
            <tr>
                <td>${item.cantidad}</td>
                <td>${item.nombre}</td>
                <td>$${subtotal.toFixed(2)}</td>
                <td class="text-end">
                    <button class="btn btn-sm btn-danger py-0" onclick="eliminarItem(${index})">&times;</button>
                </td>
            </tr>
        `;
        tbody.innerHTML += row;
    });

    // Guardamos el total puro en la variable global
    subtotalCarrito = total;

    // Actualizamos el total en la pantalla principal (sin propina aún)
    document.getElementById('total-pagar').innerText = '$' + total.toFixed(2);
}

function toggleBancos() {
    let metodo = document.getElementById('metodo_pago').value;
    let divBancos = document.getElementById('datos_bancarios');
    
    // Mostrar campos bancarios si no es efectivo
    if (metodo === 'efectivo_usd' || metodo === 'efectivo_bs') {
        divBancos.style.display = 'none';
    } else {
        divBancos.style.display = 'block';
    }
}

function abrirModalPago() {
    if (carrito.length === 0) {
        alert("El carrito está vacío.");
        return;
    }
    let cliente = document.getElementById('selectCliente').value;
    let barbero = document.getElementById('selectBarbero').value;

    if (!cliente || !barbero) {
        alert("Por favor selecciona un CLIENTE y un BARBERO.");
        return;
    }

    // NUEVO: Resetear el campo de propina a 0 siempre que se abra el modal
    let inputPropina = document.getElementById('propina');
    if(inputPropina) {
        inputPropina.value = "0.00";
    }

    // Calcular el total inicial del modal
    recalcularTotalPago();

    var modal = new bootstrap.Modal(document.getElementById('modalPago'));
    modal.show();
}

// NUEVA FUNCIÓN: Suma Items + Propina en tiempo real
function recalcularTotalPago() {
    let inputPropina = document.getElementById('propina');
    let propina = 0;
    
    if(inputPropina && inputPropina.value !== "") {
        propina = parseFloat(inputPropina.value);
    }
    
    // Validar que no sea NaN
    if(isNaN(propina)) propina = 0;

    let totalFinal = subtotalCarrito + propina;
    document.getElementById('modal-total-pagar').innerText = '$' + totalFinal.toFixed(2);
}

function procesarVenta() {
    // Obtener valor de propina
    let inputPropina = document.getElementById('propina');
    let valorPropina = inputPropina ? inputPropina.value : 0;

    let datos = {
        cliente_id: document.getElementById('selectCliente').value,
        barbero_id: document.getElementById('selectBarbero').value,
        metodo_pago: document.getElementById('metodo_pago').value,
        banco: document.getElementById('banco').value,
        referencia: document.getElementById('referencia').value,
        fecha_pago: document.getElementById('fecha_pago').value,
        observaciones: document.getElementById('observaciones').value,
        propina: valorPropina, // ENVIAMOS LA PROPINA AL BACKEND
        items: carrito
    };

    if(datos.metodo_pago !== 'efectivo_usd' && datos.metodo_pago !== 'efectivo_bs' && datos.referencia === '') {
        alert("Por favor ingresa el número de referencia.");
        return;
    }

    // Enviar a procesar_venta.php
    fetch('procesar_venta.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(datos)
    })
    .then(response => response.json())
    .then(data => {
        if (data.status === 'success') {
            alert("¡Venta registrada con éxito!");
            location.reload(); // Recargar para limpiar todo
        } else {
            alert("Error: " + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert("Error de conexión con el servidor.");
    });
}
</script>

<?php include '../includes/footer.php'; ?>