<?php
require '../includes/db.php';

// Validar sesión
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') { exit; }

$tipo = $_GET['tipo']; // 'ventas' o 'nomina'
$ini = $_GET['ini'];
$fin = $_GET['fin'];

// Nombre del archivo
$filename = "Reporte_" . ucfirst($tipo) . "_" . $ini . "_al_" . $fin . ".csv";

// Headers para forzar descarga
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=' . $filename);

// Abrir salida
$output = fopen('php://output', 'w');

// BOM para que Excel reconozca tildes y ñ (UTF-8)
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

if ($tipo == 'ventas') {
    // --- REPORTE DE VENTAS ---
    
    // Encabezados de columnas
    fputcsv($output, ['ID Venta', 'Fecha', 'Hora', 'Cliente', 'Cedula Cliente', 'Barbero', 'Metodo Pago', 'Banco', 'Referencia', 'Total Venta', 'Comision Barbero', 'Ganancia Local', 'Observaciones']);

    $sql = "SELECT s.id, s.fecha_creacion, s.total, s.metodo_pago, s.banco_origen, s.referencia_bancaria, s.observaciones,
            c.nombre as c_nom, c.apellido as c_ape, c.cedula,
            u.nombre as b_nom, u.apellido as b_ape,
            SUM(sd.comision_monto) as comision
            FROM sales s
            LEFT JOIN clients c ON s.cliente_id = c.id
            LEFT JOIN users u ON s.barbero_id = u.id
            LEFT JOIN sale_details sd ON s.id = sd.sale_id
            WHERE s.estado = 'pagada' AND DATE(s.fecha_creacion) BETWEEN ? AND ?
            GROUP BY s.id ORDER BY s.fecha_creacion DESC";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$ini, $fin]);
    
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $ganancia_local = $row['total'] - $row['comision'];
        fputcsv($output, [
            $row['id'],
            date('d/m/Y', strtotime($row['fecha_creacion'])),
            date('H:i', strtotime($row['fecha_creacion'])),
            $row['c_nom'] . ' ' . $row['c_ape'],
            $row['cedula'],
            $row['b_nom'] . ' ' . $row['b_ape'],
            ucfirst($row['metodo_pago']),
            $row['banco_origen'],
            $row['referencia_bancaria'],
            number_format($row['total'], 2, '.', ''), // Formato número simple
            number_format($row['comision'], 2, '.', ''),
            number_format($ganancia_local, 2, '.', ''),
            $row['observaciones']
        ]);
    }

} elseif ($tipo == 'nomina') {
    // --- REPORTE DE NÓMINA ---
    
    fputcsv($output, ['Barbero', 'Servicios Realizados', 'Total Comisiones (+)', 'Deuda Consumos (-)', 'TOTAL A PAGAR']);

    $barberos = $pdo->query("SELECT id, nombre, apellido FROM users WHERE rol='barbero'")->fetchAll();
    
    foreach($barberos as $b) {
        // Calcular comisiones
        $sqlC = "SELECT SUM(sd.comision_monto) as total, COUNT(*) as cant FROM sale_details sd 
                 JOIN sales s ON sd.sale_id = s.id 
                 WHERE s.barbero_id = ? AND s.estado='pagada' AND DATE(s.fecha_creacion) BETWEEN ? AND ?";
        $stmtC = $pdo->prepare($sqlC);
        $stmtC->execute([$b['id'], $ini, $fin]);
        $resC = $stmtC->fetch();

        // Calcular consumos
        $sqlD = "SELECT SUM(monto_total) as deuda FROM barber_consumptions 
                 WHERE barbero_id = ? AND DATE(fecha_consumo) BETWEEN ? AND ?";
        $stmtD = $pdo->prepare($sqlD);
        $stmtD->execute([$b['id'], $ini, $fin]);
        $resD = $stmtD->fetch();

        $ganancia = $resC['total'] ?? 0;
        $deuda = $resD['deuda'] ?? 0;
        $pagar = $ganancia - $deuda;

        fputcsv($output, [
            $b['nombre'] . ' ' . $b['apellido'],
            $resC['cant'] ?? 0,
            number_format($ganancia, 2, '.', ''),
            number_format($deuda, 2, '.', ''),
            number_format($pagar, 2, '.', '')
        ]);
    }
}

fclose($output);
exit;
?>