<?php
require '../includes/db.php';
include '../includes/header.php';

if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') {
    header("Location: ../index.php");
    exit;
}

// 1. LÓGICA PARA COBRAR CUOTA SEMANAL ($12)
if (isset($_POST['cobrar_cuota'])) {
    $barbero_id_cuota = $_POST['barbero_id_cuota'];
    $monto_cuota = 12.00;
    $concepto = "Cuota Semanal Asistente (" . date('d/m') . ")";
    
    // Insertamos en barber_consumptions usando el campo 'concepto'
    $stmtC = $pdo->prepare("INSERT INTO barber_consumptions (barbero_id, concepto, cantidad, monto_total, fecha_consumo) VALUES (?, ?, 1, ?, NOW())");
    $stmtC->execute([$barbero_id_cuota, $concepto, $monto_cuota]);
    
    $msg = "Cuota de $12 aplicada correctamente.";
}

// Filtros de fecha
$fecha_ini = isset($_GET['fecha_ini']) ? $_GET['fecha_ini'] : date('Y-m-01');
$fecha_fin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : date('Y-m-d');

// --- PESTAÑA 1: CÁLCULO DE NÓMINA ---
$barberos = $pdo->query("SELECT id, nombre, apellido FROM users WHERE rol='barbero'")->fetchAll();
$nominaData = [];

foreach($barberos as $b) {
    // A. Sumar Comisiones (70%)
    $sqlComision = "SELECT SUM(sd.comision_monto) as total_comision, COUNT(DISTINCT s.id) as cant_ventas
                    FROM sale_details sd
                    JOIN sales s ON sd.sale_id = s.id
                    WHERE s.barbero_id = ? AND s.estado = 'pagada' AND DATE(s.fecha_creacion) BETWEEN ? AND ?";
    $stmtC = $pdo->prepare($sqlComision);
    $stmtC->execute([$b['id'], $fecha_ini, $fecha_fin]);
    $resC = $stmtC->fetch();
    
    // B. Sumar Propinas (100% para barbero) - NUEVO
    $sqlPropina = "SELECT SUM(propina) as total_propina FROM sales 
                   WHERE barbero_id = ? AND estado = 'pagada' AND DATE(fecha_creacion) BETWEEN ? AND ?";
    $stmtP = $pdo->prepare($sqlPropina);
    $stmtP->execute([$b['id'], $fecha_ini, $fecha_fin]);
    $resP = $stmtP->fetch();

    // C. Sumar Consumos y Cuotas
    $sqlConsumo = "SELECT SUM(monto_total) as deuda_total FROM barber_consumptions 
                   WHERE barbero_id = ? AND DATE(fecha_consumo) BETWEEN ? AND ?";
    $stmtCons = $pdo->prepare($sqlConsumo);
    $stmtCons->execute([$b['id'], $fecha_ini, $fecha_fin]);
    $resCons = $stmtCons->fetch();
    
    // Cálculos Finales
    $comision = $resC['total_comision'] ?? 0;
    $propinas = $resP['total_propina'] ?? 0;
    $total_ingresos = $comision + $propinas; // Comisión + Propina
    $descuentos = $resCons['deuda_total'] ?? 0;
    $total_pagar = $total_ingresos - $descuentos;

    $nominaData[] = [
        'id' => $b['id'],
        'nombre' => $b['nombre'] . ' ' . $b['apellido'],
        'servicios_hechos' => $resC['cant_ventas'] ?? 0,
        'comision' => $comision,
        'propinas' => $propinas,
        'total_ingresos' => $total_ingresos,
        'descuentos' => $descuentos,
        'total_pagar' => $total_pagar
    ];
}

// --- PESTAÑA 2: DETALLE DE INGRESOS ---
$sqlDetalle = "SELECT 
                s.id, s.fecha_creacion, s.total, s.propina, s.metodo_pago, s.referencia_bancaria, s.banco_origen, s.observaciones,
                c.nombre as c_nombre, c.apellido as c_apellido, c.cedula,
                u.nombre as b_nombre, u.apellido as b_apellido,
                SUM(sd.comision_monto) as ganancia_barbero,
                (SELECT GROUP_CONCAT(
                    CONCAT(sd2.cantidad, 'x ', 
                        CASE WHEN sd2.item_type='servicio' THEN (SELECT nombre FROM services WHERE id=sd2.item_id)
                             ELSE (SELECT nombre FROM products WHERE id=sd2.item_id) END
                    ) SEPARATOR '<br>'
                 ) FROM sale_details sd2 WHERE sd2.sale_id = s.id) as items_desc
              FROM sales s
              LEFT JOIN clients c ON s.cliente_id = c.id
              LEFT JOIN users u ON s.barbero_id = u.id
              LEFT JOIN sale_details sd ON s.id = sd.sale_id
              WHERE s.estado = 'pagada' AND DATE(s.fecha_creacion) BETWEEN '$fecha_ini' AND '$fecha_fin'
              GROUP BY s.id
              ORDER BY s.fecha_creacion DESC";

$detalleVentas = $pdo->query($sqlDetalle)->fetchAll();

// Calculamos totales generales para mostrar al final de la tabla
$total_ingreso_neto = 0; // Sin propinas
$total_propinas_periodo = 0;
$total_barberos = 0;
$total_negocio = 0;
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h2 class="text-gold"><i class="fas fa-file-invoice-dollar"></i> Reportes Detallados</h2>
    </div>
    <div class="col-md-6">
        <form method="GET" class="d-flex gap-2 justify-content-end align-items-center flex-wrap">
            <input type="date" name="fecha_ini" class="form-control bg-dark text-white border-secondary" style="max-width: 140px;" value="<?php echo $fecha_ini; ?>">
            <input type="date" name="fecha_fin" class="form-control bg-dark text-white border-secondary" style="max-width: 140px;" value="<?php echo $fecha_fin; ?>">
            <button type="submit" class="btn btn-gold" title="Filtrar"><i class="fas fa-filter"></i></button>
            
            <div class="btn-group">
                <button type="button" class="btn btn-success dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="fas fa-file-excel"></i> Excel
                </button>
                <ul class="dropdown-menu dropdown-menu-dark">
                    <li><a class="dropdown-item" href="exportar_excel.php?tipo=ventas&ini=<?php echo $fecha_ini; ?>&fin=<?php echo $fecha_fin; ?>">Detalle de Ingresos</a></li>
                    <li><a class="dropdown-item" href="exportar_excel.php?tipo=nomina&ini=<?php echo $fecha_ini; ?>&fin=<?php echo $fecha_fin; ?>">Nómina Barberos</a></li>
                </ul>
            </div>

            <div class="btn-group">
                <button type="button" class="btn btn-danger dropdown-toggle" data-bs-toggle="dropdown">
                    <i class="fas fa-file-pdf"></i> PDF
                </button>
                <ul class="dropdown-menu dropdown-menu-dark">
                    <li><a class="dropdown-item" target="_blank" href="imprimir_reporte.php?tipo=ventas&ini=<?php echo $fecha_ini; ?>&fin=<?php echo $fecha_fin; ?>">Detalle de Ingresos</a></li>
                    <li><a class="dropdown-item" target="_blank" href="imprimir_reporte.php?tipo=nomina&ini=<?php echo $fecha_ini; ?>&fin=<?php echo $fecha_fin; ?>">Nómina Barberos</a></li>
                </ul>
            </div>
        </form>
    </div>
</div>

<?php if(isset($msg)) echo "<div class='alert alert-success'>$msg</div>"; ?>

<ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
  <li class="nav-item">
    <button class="nav-link active btn-gold me-2" data-bs-toggle="pill" data-bs-target="#pills-ventas">Detalle de Ingresos</button>
  </li>
  <li class="nav-item">
    <button class="nav-link btn-outline-warning" data-bs-toggle="pill" data-bs-target="#pills-nomina">Nómina (Pago Barberos)</button>
  </li>
</ul>

<div class="tab-content" id="pills-tabContent">

    <div class="tab-pane fade show active" id="pills-ventas">
        <div class="card border-warning">
            <div class="card-body table-responsive p-0">
                <table class="table table-dark table-striped table-hover table-bordered mb-0" style="font-size: 0.9rem;">
                    <thead class="bg-gold text-dark text-center">
                        <tr>
                            <th>Fecha</th>
                            <th>Método de Pago</th>
                            <th>Cliente / Barbero</th>
                            <th style="width: 25%;">Items</th>
                            <th class="bg-secondary">Total Cobrado</th>
                            <th>Propina</th>
                            <th>Ganancia<br>Barbero</th>
                            <th>Ganancia<br>Barbería</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($detalleVentas as $v): 
                            // Cálculos por fila
                            $propina = $v['propina'];
                            $total_venta = $v['total']; // Esto incluye la propina
                            $ingreso_real_local = $total_venta - $propina; // Restamos la propina para saber venta real
                            
                            $ganancia_barbero = $v['ganancia_barbero'];
                            $ganancia_negocio = $ingreso_real_local - $ganancia_barbero;
                            
                            // Acumuladores totales
                            $total_ingreso_neto += $ingreso_real_local;
                            $total_propinas_periodo += $propina;
                            $total_barberos += $ganancia_barbero;
                            $total_negocio += $ganancia_negocio;
                        ?>
                        <tr>
                            <td class="text-center">
                                <?php echo date('d/m/Y', strtotime($v['fecha_creacion'])); ?><br>
                                <small class="text-muted"><?php echo date('H:i A', strtotime($v['fecha_creacion'])); ?></small>
                            </td>

                            <td>
                                <strong class="text-gold"><?php echo strtoupper(str_replace('_', ' ', $v['metodo_pago'])); ?></strong>
                                <?php if($v['metodo_pago'] != 'efectivo_bs' && $v['metodo_pago'] != 'efectivo_usd'): ?>
                                    <div style="font-size: 0.85em;" class="mt-1">
                                        <span class="text-info">Banco:</span> <?php echo $v['banco_origen']; ?><br>
                                        <span class="text-info">Ref:</span> <?php echo $v['referencia_bancaria']; ?>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td>
                                <div class="mb-1">
                                    <i class="fas fa-user text-secondary"></i> <?php echo $v['c_nombre'].' '.$v['c_apellido']; ?><br>
                                    <small class="text-muted"><?php echo $v['cedula']; ?></small>
                                </div>
                                <div class="border-top border-secondary pt-1 mt-1">
                                    <i class="fas fa-cut text-gold"></i> <?php echo $v['b_nombre']; ?>
                                </div>
                            </td>

                            <td>
                                <span class="text-white"><?php echo $v['items_desc']; ?></span>
                                <?php if(!empty($v['observaciones'])): ?>
                                    <div class="mt-2 p-1 bg-secondary rounded fst-italic text-warning" style="font-size: 0.8em;">
                                        Obs: <?php echo $v['observaciones']; ?>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <td class="text-center bg-secondary align-middle">
                                <h5 class="text-white mb-0">$<?php echo number_format($total_venta, 2); ?></h5>
                            </td>
                            <td class="text-center align-middle text-info">
                                $<?php echo number_format($propina, 2); ?>
                            </td>
                            <td class="text-center align-middle text-warning">
                                $<?php echo number_format($ganancia_barbero, 2); ?>
                            </td>
                            <td class="text-center align-middle text-success fw-bold">
                                $<?php echo number_format($ganancia_negocio, 2); ?>
                            </td>

                            <td class="text-center align-middle">
                                <button class="btn btn-sm btn-outline-danger" title="Anular Venta" onclick="anularVenta(<?php echo $v['id']; ?>)">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot class="bg-dark border-top border-warning">
                        <tr class="text-center h5">
                            <td colspan="4" class="text-end text-gold">TOTALES DEL PERIODO:</td>
                            <td class="text-white">$<?php echo number_format($total_ingreso_neto + $total_propinas_periodo, 2); ?></td>
                            <td class="text-info">$<?php echo number_format($total_propinas_periodo, 2); ?></td>
                            <td class="text-warning">$<?php echo number_format($total_barberos, 2); ?></td>
                            <td class="text-success">$<?php echo number_format($total_negocio, 2); ?></td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
            <?php if(count($detalleVentas) == 0): ?>
                <div class="p-5 text-center text-muted">No hay ventas registradas en este rango de fechas.</div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="tab-pane fade" id="pills-nomina">
        <div class="card">
            <div class="card-header bg-secondary text-white d-flex justify-content-between">
                <span>Estado de Cuenta Barberos</span>
                <a href="consumos.php" class="btn btn-sm btn-gold">Registrar Consumo Manual</a>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-dark table-hover align-middle">
                    <thead>
                        <tr>
                            <th class="text-gold">Barbero</th>
                            <th class="text-center">Servicios</th>
                            <th>Comisión (70%)</th>
                            <th class="text-info">Propinas (100%)</th>
                            <th class="text-success">Total Generado</th>
                            <th class="text-danger">Desc. / Cuota $12</th>
                            <th class="text-gold h5">A PAGAR</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($nominaData as $n): ?>
                        <tr>
                            <td><?php echo $n['nombre']; ?></td>
                            <td class="text-center"><?php echo $n['servicios_hechos']; ?></td>
                            <td>$<?php echo number_format($n['comision'], 2); ?></td>
                            <td class="text-info fw-bold">+$<?php echo number_format($n['propinas'], 2); ?></td>
                            <td class="text-success fw-bold">$<?php echo number_format($n['total_ingresos'], 2); ?></td>
                            <td class="text-danger">-$<?php echo number_format($n['descuentos'], 2); ?></td>
                            <td><strong class="h4 text-gold">$<?php echo number_format($n['total_pagar'], 2); ?></strong></td>
                            <td>
                                <form method="POST" style="display:inline-block;" onsubmit="return confirm('¿Aplicar cuota semanal de $12 a <?php echo $n['nombre']; ?>?');">
                                    <input type="hidden" name="cobrar_cuota" value="1">
                                    <input type="hidden" name="barbero_id_cuota" value="<?php echo $n['id']; ?>">
                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Descontar $12 Semanal">
                                        -$12
                                    </button>
                                </form>

                                <button class="btn btn-sm btn-outline-info" onclick="verDetalle(<?php echo $n['id']; ?>)">
                                    <i class="fas fa-list"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>

<div class="modal fade" id="modalDetalleNomina" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content bg-dark text-white border-warning">
            <div class="modal-header">
                <h5 class="modal-title">Detalle de Servicios</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="contenidoDetalle">
                Cargando...
            </div>
        </div>
    </div>
</div>

<script>
function verDetalle(barberoId) {
    var modal = new bootstrap.Modal(document.getElementById('modalDetalleNomina'));
    modal.show();
    let ini = '<?php echo $fecha_ini; ?>';
    let fin = '<?php echo $fecha_fin; ?>';
    fetch('ver_detalle_nomina.php?id=' + barberoId + '&ini=' + ini + '&fin=' + fin)
        .then(response => response.text())
        .then(html => { document.getElementById('contenidoDetalle').innerHTML = html; });
}

function anularVenta(id) {
    if(confirm('¿ESTÁ SEGURO DE BORRAR/ANULAR ESTA VENTA? \nEsto devolverá el stock y restará la ganancia.')) {
        window.location.href = 'anular_venta.php?id=' + id;
    }
}
</script>

<?php include '../includes/footer.php'; ?>