<?php
require '../includes/db.php';
// Solo backend, sin header
$id = $_GET['id'];
$ini = $_GET['ini'];
$fin = $_GET['fin'];

// Buscar servicios realizados en ese rango
$sql = "SELECT s.fecha_creacion, serv.nombre, sd.precio_unitario, sd.comision_monto
        FROM sale_details sd
        JOIN sales s ON sd.sale_id = s.id
        JOIN services serv ON sd.item_id = serv.id
        WHERE s.barbero_id = ? 
        AND sd.item_type = 'servicio'
        AND s.estado = 'pagada'
        AND DATE(s.fecha_creacion) BETWEEN ? AND ?";
        
$stmt = $pdo->prepare($sql);
$stmt->execute([$id, $ini, $fin]);
$servicios = $stmt->fetchAll();

if(count($servicios) == 0) {
    echo "<p class='text-center'>No hay servicios registrados en este periodo.</p>";
} else {
    echo "<table class='table table-dark table-sm'>";
    echo "<thead><tr><th>Fecha</th><th>Servicio</th><th>Precio</th><th>Comisión (70%)</th></tr></thead><tbody>";
    foreach($servicios as $s){
        echo "<tr>";
        echo "<td>".date('d/m H:i', strtotime($s['fecha_creacion']))."</td>";
        echo "<td>".$s['nombre']."</td>";
        echo "<td>$".$s['precio_unitario']."</td>";
        echo "<td class='text-success'>+$".$s['comision_monto']."</td>";
        echo "</tr>";
    }
    echo "</tbody></table>";
}
?>