<?php
require 'includes/db.php';

// Si ya está logueado, mandar al dashboard
if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = :u AND activo = 1 LIMIT 1");
    $stmt->execute(['u' => $username]);
    $user = $stmt->fetch();

    // Verificamos contraseña (hash)
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['nombre'] = $user['nombre'];
        $_SESSION['rol'] = $user['rol'];
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Usuario o contraseña incorrectos.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Login Barbería</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #1a1a1a; display: flex; align-items: center; justify-content: center; height: 100vh; }
        .login-card { background-color: #2c2c2c; border: 2px solid #d4af37; color: white; width: 100%; max-width: 400px; padding: 2rem; border-radius: 10px; }
        .btn-gold { background-color: #d4af37; color: black; font-weight: bold; border: none; width: 100%; }
        .btn-gold:hover { background-color: #b59025; }
        .form-control { background-color: #444; border: 1px solid #666; color: white; }
    </style>
</head>
<body>
    <div class="login-card">
        <h3 class="text-center mb-4" style="color: #d4af37;">BARBER SHOP</h3>
        <?php if($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        <form method="POST">
            <div class="mb-3">
                <label>Usuario</label>
                <input type="text" name="username" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Contraseña</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-gold">INGRESAR</button>
        </form>
    </div>
</body>
</html>