<?php
require '../includes/db.php';

// Seguridad: Solo Admin
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') {
    header("Location: ../index.php");
    exit;
}

// PROCESAR FORMULARIO
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];
    $cedula = $_POST['cedula'];
    $nombre = $_POST['nombre'];
    $apellido = $_POST['apellido'];
    $fecha_nac = $_POST['fecha_nacimiento'];
    $username = $_POST['username'];
    $activo = isset($_POST['activo']) ? 1 : 0;
    
    // Manejo de contraseña
    $password = $_POST['password'];
    
    try {
        if ($action == 'create') {
            // Encriptamos la contraseña
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (cedula, nombre, apellido, fecha_nacimiento, username, password, rol, activo) VALUES (?, ?, ?, ?, ?, ?, 'barbero', ?)");
            $stmt->execute([$cedula, $nombre, $apellido, $fecha_nac, $username, $hash, $activo]);
            
        } elseif ($action == 'edit') {
            $id = $_POST['id'];
            
            // Si el campo password está vacío, NO actualizamos la clave, solo los datos
            if(empty($password)){
                $stmt = $pdo->prepare("UPDATE users SET cedula=?, nombre=?, apellido=?, fecha_nacimiento=?, username=?, activo=? WHERE id=?");
                $stmt->execute([$cedula, $nombre, $apellido, $fecha_nac, $username, $activo, $id]);
            } else {
                // Si escribió algo, actualizamos la clave también
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("UPDATE users SET cedula=?, nombre=?, apellido=?, fecha_nacimiento=?, username=?, password=?, activo=? WHERE id=?");
                $stmt->execute([$cedula, $nombre, $apellido, $fecha_nac, $username, $hash, $activo, $id]);
            }
        }
    } catch (PDOException $e) {
        $error = "Error: La cédula o el usuario ya existen.";
    }
    
    if(!isset($error)) {
        header("Location: barberos.php");
        exit;
    }
}

// Obtener solo Barberos (excluyendo admin)
$stmt = $pdo->query("SELECT * FROM users WHERE rol = 'barbero' ORDER BY nombre ASC");
$barberos = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="text-gold"><i class="fas fa-users"></i> Gestión de Barberos</h2>
    <button class="btn btn-gold" data-bs-toggle="modal" data-bs-target="#modalBarbero" onclick="limpiarModal()">
        <i class="fas fa-user-plus"></i> Nuevo Barbero
    </button>
</div>

<?php if(isset($error)): ?>
    <div class="alert alert-danger"><?php echo $error; ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle">
            <thead>
                <tr>
                    <th class="text-gold">Estado</th>
                    <th class="text-gold">Cédula</th>
                    <th class="text-gold">Nombre Completo</th>
                    <th class="text-gold">Usuario</th>
                    <th class="text-gold text-end">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($barberos as $b): ?>
                <tr class="<?php echo $b['activo'] == 0 ? 'opacity-50' : ''; ?>">
                    <td>
                        <?php if($b['activo']): ?>
                            <span class="badge bg-success">Activo</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Inactivo</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo $b['cedula']; ?></td>
                    <td><?php echo $b['nombre'] . ' ' . $b['apellido']; ?></td>
                    <td><i class="fas fa-user text-secondary"></i> <?php echo $b['username']; ?></td>
                    <td class="text-end">
                        <button class="btn btn-sm btn-outline-warning" onclick="editar(<?php echo htmlspecialchars(json_encode($b)); ?>)">
                            <i class="fas fa-edit"></i> Editar / Clave
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalBarbero" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content bg-dark text-white border-warning">
            <form method="POST" autocomplete="off"> <div class="modal-header border-secondary">
                    <h5 class="modal-title text-gold" id="modalTitle">Nuevo Barbero</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" id="action" value="create">
                    <input type="hidden" name="id" id="id">
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Cédula</label>
                            <input type="text" name="cedula" id="cedula" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Fecha Nacimiento</label>
                            <input type="date" name="fecha_nacimiento" id="fecha_nacimiento" class="form-control" required>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Nombre</label>
                            <input type="text" name="nombre" id="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Apellido</label>
                            <input type="text" name="apellido" id="apellido" class="form-control" required>
                        </div>
                    </div>

                    <hr class="border-secondary">
                    <h6 class="text-gold">Datos de Acceso</h6>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Usuario (Login)</label>
                            <input type="text" name="username" id="username" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Contraseña</label>
                            <input type="password" name="password" id="password" class="form-control" placeholder="Dejar en blanco si no se quiere cambiar">
                            <small class="text-muted" id="passHelp">Requerida para crear nuevo usuario.</small>
                        </div>
                    </div>

                    <div class="form-check form-switch mt-2">
                        <input class="form-check-input" type="checkbox" name="activo" id="activo" checked>
                        <label class="form-check-label" for="activo">Barbero Activo (Puede acceder al sistema)</label>
                    </div>

                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-gold">Guardar Datos</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function limpiarModal() {
    document.getElementById('modalTitle').innerText = 'Nuevo Barbero';
    document.getElementById('action').value = 'create';
    document.getElementById('cedula').value = '';
    document.getElementById('nombre').value = '';
    document.getElementById('apellido').value = '';
    document.getElementById('fecha_nacimiento').value = '';
    document.getElementById('username').value = '';
    document.getElementById('password').value = '';
    document.getElementById('password').required = true; // Clave obligatoria al crear
    document.getElementById('passHelp').innerText = 'Requerida para crear usuario.';
    document.getElementById('activo').checked = true;
}

function editar(data) {
    var modal = new bootstrap.Modal(document.getElementById('modalBarbero'));
    document.getElementById('modalTitle').innerText = 'Editar Barbero';
    document.getElementById('action').value = 'edit';
    document.getElementById('id').value = data.id;
    document.getElementById('cedula').value = data.cedula;
    document.getElementById('nombre').value = data.nombre;
    document.getElementById('apellido').value = data.apellido;
    document.getElementById('fecha_nacimiento').value = data.fecha_nacimiento;
    document.getElementById('username').value = data.username;
    
    // Clave opcional al editar
    document.getElementById('password').value = '';
    document.getElementById('password').required = false;
    document.getElementById('passHelp').innerText = 'Dejar vacío para mantener la contraseña actual.';
    
    document.getElementById('activo').checked = (data.activo == 1);
    modal.show();
}
</script>

<?php include '../includes/footer.php'; ?>