<?php
require '../includes/db.php';

// Auth: Admin y Barberos pueden ver, pero editar/borrar dejemoslo al admin por seguridad, 
// o permitamos todo. Según tu prompt, se debe poder crear/editar/eliminar.
// Permitiré acceso a ambos roles.
if (!isset($_SESSION['user_id'])) {
    header("Location: ../index.php");
    exit;
}

// PROCESAR FORMULARIO
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'];
    $cedula = $_POST['cedula'];
    $nombre = $_POST['nombre'];
    $apellido = $_POST['apellido'];
    $fecha_nac = $_POST['fecha_nacimiento'];

    try {
        if ($action == 'delete') {
            // Solo admin borra
            if($_SESSION['rol'] == 'admin'){
                $id = $_POST['id'];
                $stmt = $pdo->prepare("DELETE FROM clients WHERE id = ?");
                $stmt->execute([$id]);
            }
        } elseif ($action == 'create') {
            $stmt = $pdo->prepare("INSERT INTO clients (cedula, nombre, apellido, fecha_nacimiento) VALUES (?, ?, ?, ?)");
            $stmt->execute([$cedula, $nombre, $apellido, $fecha_nac]);
        } elseif ($action == 'edit') {
            $id = $_POST['id'];
            $stmt = $pdo->prepare("UPDATE clients SET cedula=?, nombre=?, apellido=?, fecha_nacimiento=? WHERE id=?");
            $stmt->execute([$cedula, $nombre, $apellido, $fecha_nac, $id]);
        }
    } catch (PDOException $e) {
        $error = "Error: Cédula ya registrada.";
    }

    if(!isset($error)) {
        header("Location: clientes.php");
        exit;
    }
}

// Búsqueda simple
$busqueda = isset($_GET['q']) ? $_GET['q'] : '';
if($busqueda){
    $stmt = $pdo->prepare("SELECT * FROM clients WHERE nombre LIKE ? OR apellido LIKE ? OR cedula LIKE ? LIMIT 50");
    $stmt->execute(["%$busqueda%", "%$busqueda%", "%$busqueda%"]);
} else {
    $stmt = $pdo->query("SELECT * FROM clients ORDER BY id DESC LIMIT 20"); // Solo últimos 20 para no saturar
}
$clientes = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="row mb-4 align-items-center">
    <div class="col-md-6">
        <h2 class="text-gold"><i class="fas fa-users-cog"></i> Cartera de Clientes</h2>
    </div>
    <div class="col-md-6 text-end">
        <button class="btn btn-gold" data-bs-toggle="modal" data-bs-target="#modalCliente" onclick="limpiarModal()">
            <i class="fas fa-plus"></i> Nuevo Cliente
        </button>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" class="row g-2">
            <div class="col-md-10">
                <input type="text" name="q" class="form-control" placeholder="Buscar por Cédula, Nombre o Apellido..." value="<?php echo htmlspecialchars($busqueda); ?>">
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-outline-warning w-100">Buscar</button>
            </div>
        </form>
    </div>
</div>

<?php if(isset($error)): ?>
    <div class="alert alert-danger"><?php echo $error; ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-body table-responsive">
        <table class="table table-dark table-hover align-middle">
            <thead>
                <tr>
                    <th class="text-gold">Cédula</th>
                    <th class="text-gold">Nombre Completo</th>
                    <th class="text-gold">Fecha Nac.</th>
                    <th class="text-gold text-end">Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($clientes as $c): ?>
                <tr>
                    <td><?php echo $c['cedula']; ?></td>
                    <td><?php echo $c['nombre'] . ' ' . $c['apellido']; ?></td>
                    <td>
                        <?php 
                        if($c['fecha_nacimiento']) {
                            $date = new DateTime($c['fecha_nacimiento']);
                            echo $date->format('d/m/Y');
                        } else {
                            echo "---";
                        }
                        ?>
                    </td>
                    <td class="text-end">
                        <button class="btn btn-sm btn-outline-warning" onclick="editar(<?php echo htmlspecialchars(json_encode($c)); ?>)">
                            <i class="fas fa-edit"></i>
                        </button>
                        <?php if($_SESSION['rol'] == 'admin'): ?>
                        <form method="POST" style="display:inline-block;" onsubmit="return confirm('¿Eliminar cliente? Se borrará su historial.');">
                            <input type="hidden" name="action" value="delete">
                            <input type="hidden" name="id" value="<?php echo $c['id']; ?>">
                            <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modalCliente" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white border-warning">
            <form method="POST">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title text-gold" id="modalTitle">Nuevo Cliente</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" id="action" value="create">
                    <input type="hidden" name="id" id="id">
                    
                    <div class="mb-3">
                        <label>Cédula / Identificación</label>
                        <input type="text" name="cedula" id="cedula" class="form-control" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Nombre</label>
                            <input type="text" name="nombre" id="nombre" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Apellido</label>
                            <input type="text" name="apellido" id="apellido" class="form-control" required>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label>Fecha Nacimiento</label>
                        <input type="date" name="fecha_nacimiento" id="fecha_nacimiento" class="form-control">
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-gold">Guardar Cliente</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function limpiarModal() {
    document.getElementById('modalTitle').innerText = 'Nuevo Cliente';
    document.getElementById('action').value = 'create';
    document.getElementById('cedula').value = '';
    document.getElementById('nombre').value = '';
    document.getElementById('apellido').value = '';
    document.getElementById('fecha_nacimiento').value = '';
}

function editar(data) {
    var modal = new bootstrap.Modal(document.getElementById('modalCliente'));
    document.getElementById('modalTitle').innerText = 'Editar Cliente';
    document.getElementById('action').value = 'edit';
    document.getElementById('id').value = data.id;
    document.getElementById('cedula').value = data.cedula;
    document.getElementById('nombre').value = data.nombre;
    document.getElementById('apellido').value = data.apellido;
    document.getElementById('fecha_nacimiento').value = data.fecha_nacimiento;
    modal.show();
}
</script>

<?php include '../includes/footer.php'; ?>