<?php
require '../includes/db.php';

// Validar acceso
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] != 'admin') { die("Acceso denegado"); }

$tipo = $_GET['tipo'];
$ini = $_GET['ini'];
$fin = $_GET['fin'];
$titulo = ($tipo == 'ventas') ? "REPORTE DETALLADO DE INGRESOS" : "REPORTE DE NÓMINA (PAGOS)";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Imprimir Reporte</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 11px; color: #000; }
        .header { text-align: center; margin-bottom: 20px; border-bottom: 2px solid #000; padding-bottom: 10px; }
        .header h1 { margin: 0; font-size: 16px; text-transform: uppercase; }
        .header p { margin: 3px 0 0; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #999; padding: 5px; text-align: left; vertical-align: top; }
        th { background-color: #eee; font-weight: bold; text-align: center; }
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .total-row { font-weight: bold; background-color: #f0f0f0; }
        .item-list { font-size: 0.9em; color: #333; }
        
        @media print {
            @page { margin: 1cm; size: A4 landscape; } /* Hoja horizontal para que quepa todo */
            body { -webkit-print-color-adjust: exact; }
        }
    </style>
</head>
<body onload="window.print()">

    <div class="header">
        <h1>SISTEMA DE BARBERÍA</h1>
        <p><strong><?php echo $titulo; ?></strong></p>
        <p>Desde: <?php echo date('d/m/Y', strtotime($ini)); ?> | Hasta: <?php echo date('d/m/Y', strtotime($fin)); ?></p>
        <p>Generado por: <?php echo $_SESSION['nombre']; ?> | Fecha: <?php echo date('d/m/Y H:i'); ?></p>
    </div>

    <?php if ($tipo == 'ventas'): 
        // Consulta SQL corregida (Misma lógica que reportes.php)
        $sql = "SELECT 
                    s.id, s.fecha_creacion, s.total, s.metodo_pago, s.banco_origen, s.referencia_bancaria, s.observaciones,
                    c.nombre as c_nom, c.apellido as c_ape, c.cedula,
                    u.nombre as b_nom, u.apellido as b_ape,
                    SUM(sd.comision_monto) as comision,
                    (SELECT GROUP_CONCAT(
                        CONCAT(sd2.cantidad, 'x ', 
                            CASE 
                                WHEN sd2.item_type='servicio' THEN (SELECT nombre FROM services WHERE id=sd2.item_id)
                                ELSE (SELECT nombre FROM products WHERE id=sd2.item_id) 
                            END
                        ) SEPARATOR ', '
                    ) FROM sale_details sd2 WHERE sd2.sale_id = s.id) as items
                FROM sales s
                LEFT JOIN clients c ON s.cliente_id = c.id
                LEFT JOIN users u ON s.barbero_id = u.id
                LEFT JOIN sale_details sd ON s.id = sd.sale_id
                WHERE s.estado = 'pagada' AND DATE(s.fecha_creacion) BETWEEN ? AND ?
                GROUP BY s.id 
                ORDER BY s.fecha_creacion DESC";
                
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$ini, $fin]);
        $ventas = $stmt->fetchAll();
        
        $t_total = 0; $t_barbero = 0; $t_local = 0;
        
        if(count($ventas) > 0):
    ?>
        <table>
            <thead>
                <tr>
                    <th style="width: 10%;">Fecha</th>
                    <th style="width: 15%;">Cliente</th>
                    <th style="width: 10%;">Barbero</th>
                    <th style="width: 25%;">Detalle Items</th>
                    <th style="width: 15%;">Método Pago</th>
                    <th style="width: 8%;">Total</th>
                    <th style="width: 8%;">Gan. Local</th>
                    <th style="width: 9%;">Observación</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($ventas as $v): 
                    $ganancia_local = $v['total'] - $v['comision'];
                    $t_total += $v['total'];
                    $t_barbero += $v['comision'];
                    $t_local += $ganancia_local;
                ?>
                <tr>
                    <td class="text-center">
                        <?php echo date('d/m/Y', strtotime($v['fecha_creacion'])); ?><br>
                        <?php echo date('H:i', strtotime($v['fecha_creacion'])); ?>
                    </td>
                    <td>
                        <?php echo $v['c_nom'].' '.$v['c_ape']; ?><br>
                        <small>CI: <?php echo $v['cedula']; ?></small>
                    </td>
                    <td><?php echo $v['b_nom']; ?></td>
                    <td><span class="item-list"><?php echo $v['items']; ?></span></td>
                    <td>
                        <?php echo strtoupper(str_replace('_',' ',$v['metodo_pago'])); ?>
                        <?php if($v['referencia_bancaria']): ?>
                            <br><small>Ref: <?php echo $v['referencia_bancaria']; ?></small>
                            <br><small>Banco: <?php echo $v['banco_origen']; ?></small>
                        <?php endif; ?>
                    </td>
                    <td class="text-right">$<?php echo number_format($v['total'], 2); ?></td>
                    <td class="text-right">$<?php echo number_format($ganancia_local, 2); ?></td>
                    <td><small><?php echo $v['observaciones']; ?></small></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <td colspan="5" class="text-right">TOTALES GENERALES:</td>
                    <td class="text-right">$<?php echo number_format($t_total, 2); ?></td>
                    <td class="text-right">$<?php echo number_format($t_local, 2); ?></td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
        
        <?php else: ?>
            <p style="text-align: center; margin-top: 50px;">No se encontraron registros para este rango de fechas.</p>
        <?php endif; ?>

    <?php elseif ($tipo == 'nomina'): 
        $barberos = $pdo->query("SELECT id, nombre, apellido FROM users WHERE rol='barbero'")->fetchAll();
    ?>
        <table>
            <thead>
                <tr>
                    <th>Barbero</th>
                    <th class="text-center">Servicios Realizados</th>
                    <th class="text-right">Comisión Generada (+)</th>
                    <th class="text-right">Descuento Consumos (-)</th>
                    <th class="text-right">TOTAL A PAGAR</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($barberos as $b):
                    // Calcular
                    $sqlC = "SELECT SUM(sd.comision_monto) as total, COUNT(*) as cant FROM sale_details sd 
                             JOIN sales s ON sd.sale_id = s.id 
                             WHERE s.barbero_id = ? AND s.estado='pagada' AND DATE(s.fecha_creacion) BETWEEN ? AND ?";
                    $stmtC = $pdo->prepare($sqlC);
                    $stmtC->execute([$b['id'], $ini, $fin]);
                    $resC = $stmtC->fetch();

                    $sqlD = "SELECT SUM(monto_total) as deuda FROM barber_consumptions 
                             WHERE barbero_id = ? AND DATE(fecha_consumo) BETWEEN ? AND ?";
                    $stmtD = $pdo->prepare($sqlD);
                    $stmtD->execute([$b['id'], $ini, $fin]);
                    $resD = $stmtD->fetch();

                    $ganancia = $resC['total'] ?? 0;
                    $deuda = $resD['deuda'] ?? 0;
                    $pagar = $ganancia - $deuda;
                ?>
                <tr>
                    <td><?php echo $b['nombre'].' '.$b['apellido']; ?></td>
                    <td class="text-center"><?php echo $resC['cant'] ?? 0; ?></td>
                    <td class="text-right">$<?php echo number_format($ganancia, 2); ?></td>
                    <td class="text-right text-danger">-$<?php echo number_format($deuda, 2); ?></td>
                    <td class="text-right total-row">$<?php echo number_format($pagar, 2); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>

</body>
</html>