<?php
require '../includes/db.php';
include '../includes/header.php';

// Solo Barberos (y admin si quiere ver como se ve)
if (!isset($_SESSION['user_id'])) { header("Location: ../index.php"); exit; }

$barbero_id = $_SESSION['user_id'];
$msg = '';
$error = '';

// --- PROCESAR FORMULARIOS ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // 1. REGISTRAR NUEVO SERVICIO
    if (isset($_POST['action']) && $_POST['action'] == 'create') {
        $service_id = $_POST['service_id'];
        
        // Calcular estimación
        $stmtS = $pdo->prepare("SELECT precio, requiere_lavado FROM services WHERE id = ?");
        $stmtS->execute([$service_id]);
        $serv = $stmtS->fetch();
        
        if($serv){
            $base = $serv['precio'];
            if($serv['requiere_lavado'] == 1) $base -= 1;
            $comision_estimada = $base * 0.70;
            
            $stmt = $pdo->prepare("INSERT INTO work_logs (barbero_id, service_id, comision_estimada) VALUES (?, ?, ?)");
            $stmt->execute([$barbero_id, $service_id, $comision_estimada]);
            
            $msg = "¡Servicio registrado exitosamente!";
        }
    }

    // 2. ELIMINAR SERVICIO (Solo si pertenece a este barbero)
    if (isset($_POST['action']) && $_POST['action'] == 'delete') {
        $id_log = $_POST['id'];
        $stmtDel = $pdo->prepare("DELETE FROM work_logs WHERE id = ? AND barbero_id = ?");
        $stmtDel->execute([$id_log, $barbero_id]);
        $msg = "Registro eliminado.";
    }

    // 3. EDITAR SERVICIO (Si se equivocó de corte)
    if (isset($_POST['action']) && $_POST['action'] == 'edit') {
        $id_log = $_POST['id'];
        $nuevo_service_id = $_POST['service_id'];

        // Recalcular la comisión con el nuevo servicio
        $stmtS = $pdo->prepare("SELECT precio, requiere_lavado FROM services WHERE id = ?");
        $stmtS->execute([$nuevo_service_id]);
        $serv = $stmtS->fetch();

        if($serv){
            $base = $serv['precio'];
            if($serv['requiere_lavado'] == 1) $base -= 1;
            $nueva_comision = $base * 0.70;

            // Actualizamos asegurando que sea el dueño del registro
            $stmtUpd = $pdo->prepare("UPDATE work_logs SET service_id = ?, comision_estimada = ? WHERE id = ? AND barbero_id = ?");
            $stmtUpd->execute([$nuevo_service_id, $nueva_comision, $id_log, $barbero_id]);
            
            $msg = "Registro corregido correctamente.";
        }
    }
}

// Filtros para su reporte personal
$fecha_ini = isset($_GET['fecha_ini']) ? $_GET['fecha_ini'] : date('Y-m-01');
$fecha_fin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : date('Y-m-d');

// Consultar sus servicios registrados
$sql = "SELECT w.*, s.nombre, s.precio 
        FROM work_logs w 
        JOIN services s ON w.service_id = s.id 
        WHERE w.barbero_id = ? AND DATE(w.fecha_registro) BETWEEN ? AND ?
        ORDER BY w.fecha_registro DESC";
$stmtList = $pdo->prepare($sql);
$stmtList->execute([$barbero_id, $fecha_ini, $fecha_fin]);
$mis_servicios = $stmtList->fetchAll();

// Totales
$total_estimado = 0;
$cantidad_servicios = 0;
foreach($mis_servicios as $m) {
    $total_estimado += $m['comision_estimada'];
    $cantidad_servicios++;
}

// Cargar lista de servicios disponibles
$servicios_disponibles = $pdo->query("SELECT * FROM services WHERE activo = 1 ORDER BY nombre ASC")->fetchAll();
?>

<div class="row">
    <div class="col-md-4">
        <div class="card border-gold mb-4">
            <div class="card-header bg-gold text-dark fw-bold">
                <i class="fas fa-plus-circle"></i> Registrar Servicio
            </div>
            <div class="card-body">
                <?php if($msg): ?>
                    <div class="alert alert-success py-2"><?php echo $msg; ?></div>
                <?php endif; ?>
                
                <p class="text-muted small">Selecciona el servicio que acabas de terminar.</p>
                
                <form method="POST">
                    <input type="hidden" name="action" value="create">
                    <div class="mb-3">
                        <label class="text-gold">Servicio Realizado</label>
                        <select name="service_id" class="form-select bg-dark text-white border-secondary" required>
                            <option value="">-- Seleccionar --</option>
                            <?php foreach($servicios_disponibles as $sd): ?>
                                <option value="<?php echo $sd['id']; ?>">
                                    <?php echo $sd['nombre']; ?> ($<?php echo $sd['precio']; ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-gold w-100 py-2">Registrar</button>
                </form>
            </div>
        </div>
        
        <div class="card bg-dark border-secondary">
            <div class="card-body text-center">
                <h5 class="text-muted">Ganancia Estimada</h5>
                <h2 class="text-success">$<?php echo number_format($total_estimado, 2); ?></h2>
                <small class="text-white"><?php echo $cantidad_servicios; ?> servicios registrados en este rango.</small>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h3 class="text-gold">Mi Historial</h3>
            <form method="GET" class="d-flex gap-2">
                <input type="date" name="fecha_ini" class="form-control bg-secondary text-white border-0" value="<?php echo $fecha_ini; ?>">
                <input type="date" name="fecha_fin" class="form-control bg-secondary text-white border-0" value="<?php echo $fecha_fin; ?>">
                <button type="submit" class="btn btn-gold"><i class="fas fa-search"></i></button>
            </form>
        </div>

        <div class="card border-warning">
            <div class="card-body table-responsive p-0">
                <table class="table table-dark table-hover table-striped mb-0 align-middle">
                    <thead>
                        <tr>
                            <th>Fecha/Hora</th>
                            <th>Servicio</th>
                            <th>Precio</th>
                            <th class="text-gold">Tu 70%</th>
                            <th class="text-end">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($mis_servicios as $ms): ?>
                        <tr>
                            <td><?php echo date('d/m H:i', strtotime($ms['fecha_registro'])); ?></td>
                            <td><?php echo $ms['nombre']; ?></td>
                            <td class="text-muted">$<?php echo $ms['precio']; ?></td>
                            <td class="text-gold fw-bold">$<?php echo number_format($ms['comision_estimada'], 2); ?></td>
                            <td class="text-end">
                                <button class="btn btn-sm btn-outline-info" onclick="editar(<?php echo htmlspecialchars(json_encode($ms)); ?>)">
                                    <i class="fas fa-pen"></i>
                                </button>
                                <form method="POST" style="display:inline-block;" onsubmit="return confirm('¿Te equivocaste y quieres borrar este registro?');">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id" value="<?php echo $ms['id']; ?>">
                                    <button type="submit" class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        
                        <?php if(count($mis_servicios) == 0): ?>
                            <tr><td colspan="5" class="text-center py-4 text-muted">No has registrado servicios.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white border-warning">
            <form method="POST">
                <div class="modal-header border-secondary">
                    <h5 class="modal-title text-gold">Corregir Servicio</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="action" value="edit">
                    <input type="hidden" name="id" id="edit_id">
                    
                    <p class="text-muted small">Si seleccionaste el corte incorrecto, cámbialo aquí.</p>

                    <div class="mb-3">
                        <label class="text-gold">Servicio Correcto</label>
                        <select name="service_id" id="edit_service_id" class="form-select bg-secondary text-white border-0" required>
                            <?php foreach($servicios_disponibles as $sd): ?>
                                <option value="<?php echo $sd['id']; ?>">
                                    <?php echo $sd['nombre']; ?> ($<?php echo $sd['precio']; ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer border-secondary">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-gold">Guardar Corrección</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editar(data) {
    var modal = new bootstrap.Modal(document.getElementById('modalEditar'));
    document.getElementById('edit_id').value = data.id;
    document.getElementById('edit_service_id').value = data.service_id;
    modal.show();
}
</script>

<?php include '../includes/footer.php'; ?>